﻿//////////////////////////////////////////////
// ToolBar.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class ContextMenu ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "../Enums/Alignment.h"

#include "Component.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>

/// Internals --------------------------------

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ToolBar : public Component
	{
		public :

			// Item
			class Item
			{
				public :

					// Constructor, destructor
					Item () noexcept ;
					virtual ~Item () ;

					// Getters
					virtual nkMemory::StringView getLabel () const = 0 ;
					virtual std::function<void ()> getCallback () const = 0 ;
					virtual ContextMenu* getContextMenu () const = 0 ;
			} ;

		public :

			// Constructor, destructor
			ToolBar (System* system) noexcept ;
			virtual ~ToolBar () ;

			// Getters
			virtual Item* getItem (unsigned int index) const = 0 ;
			virtual unsigned int getItemCount () const = 0 ;

			// Setters
			void setItemOrigin (ALIGNMENT value) ;

			// Content creation
			virtual Item* addItem (nkMemory::StringView label, std::function<void ()> callback) = 0 ;
			virtual void clearItems () = 0 ;

			// Recomputations
			virtual void recomputeSizeToFitItems () = 0 ;

		public :

			// Statics
			static nkMemory::UniquePtr<ToolBar> create (System* system = nullptr) ;

		protected :

			// Attributes
			// Alignment side
			ALIGNMENT _itemOrigin ;
	} ;
}